# -*- coding: latin-1 -*-
#
# ghettovcb.py
#
# mkbackup ghettovcb frontent
#



#Once ESXi comes back up open the vSphere client as you need to enable OEM CIM providers.
#
#   1. Choose the Configuration tab on the host
#   2. Click Advanced Settings under the Software section
#   3. In the dialog that appears click "UserVars" on the left
#   4. Change the value of CIMOEMProvidersEnabled to 1
#   5. Click OK
#From here if you have access to the ESXi console hit  and select Restart Management Agents. Otherwise you will need to reboot the host again.

import os, string, subprocess, fnmatch, platform
import posixpath

from datetime import datetime, timedelta

#import paramiko
import pywbem

from archiver import *
import cron


test_class='VMware_Controller'
#test_class='CIM_Memory'

default_class_list=[
    'CIM_Sensor', 
    'CIM_PowerSupply',
    'CIM_Chassis', 
    'CIM_ComputerSystem',
    'CIM_NumericSensor',
    'CIM_Memory',
    'CIM_PhysicalMemory',
    'CIM_Processor', 
    'CIM_LogRecord',
    'CIM_RecordLog',
    'CIM_EthernetPort',

    'CIM_SoftwareIdentity', 
    
    'OMC_SMASHFirmwareIdentity',
    'OMC_DiscreteSensor', 
    'OMC_Fan', 
    'OMC_PowerSupply',

    'OMC_RawIpmiSensor',
    'OMC_RawIpmiEntity',
    
    'VMware_StorageExtent',
    'VMware_Controller',
    'VMware_StorageVolume',
    'VMware_Battery',
    'VMware_SASSATAPort',
]

ExitUnknown = -1
ExitOK = 0
ExitWarning = 1
ExitCritical = 2

class ESXMon(Archiver):
    
    name='esxmon'

    types=dict( mon='mon')
    
    NS = 'root/cimv2'


    interpret=dict( HealthState = {
                        0  : ExitOK,        # Unknown
                        5  : ExitOK,        # OK
                        10 : ExitWarning,    # Degraded
                        15 : ExitWarning,    # Minor
                        20 : ExitCritical,    # Major
                        25 : ExitCritical,    # Critical
                        30 : ExitCritical,    # Non-recoverable Error
                    },
                    OperationalStatus = {
                        0  : ExitOK,            # Unknown
                        1  : ExitCritical,      # Other
                        2  : ExitOK,            # OK
                        3  : ExitWarning,       # Degraded
                        4  : ExitWarning,       # Stressed
                        5  : ExitWarning,       # Predictive Failure
                        6  : ExitCritical,      # Error
                        7  : ExitCritical,      # Non-Recoverable Error
                        8  : ExitWarning,       # Starting
                        9  : ExitWarning,       # Stopping
                        10 : ExitCritical,      # Stopped
                        11 : ExitOK,            # In Service
                        12 : ExitWarning,       # No Contact
                        13 : ExitCritical,      # Lost Communication
                        14 : ExitCritical,      # Aborted
                        15 : ExitOK,            # Dormant
                        16 : ExitCritical,      # Supporting Entity in Error
                        17 : ExitOK,            # Completed
                        18 : ExitOK,            # Power Mode
                        19 : ExitOK,            # DMTF Reserved
                        20 : ExitOK             # Vendor Reserved
                    })

    # -----------------------------------------------------------------------
    def __init__(self):
        Archiver.__init__(self)
        
        self.url=None
        self.login=None
        self.password=None

        self.class_list=[]
        self.class_include=[]
        self.class_exclude=[]
        self.property_exclude=[]
        
        self.classData = {} # Dictionary to cache class metadata
        
        self.verbose=False
        self.friendly_value=False
        
        
    
    # -----------------------------------------------------------------------
    def load(self, job, manager):
        
        
        raise RuntimeError, u'hllo'
    
        log=manager.log
        now=manager.now
        
        errors, warnings, extra={}, {}, ''

        for name in ('url', 'login', 'password'):
            value=job.get(name, None)
            if not value:
                errors[name]='option mandatory'
            else:
                setattr(self, name, value)
                if name=='password':
                    self.register_password(value)


        self.verbose=boolean.get(job.get('verbose', 'no').lower(), None)
        if self.verbose==None:
            errors['verbose']='boolean must have value in (on, yes, true, 1, off, no, false and 0)'

        self.friendly_value=boolean.get(job.get('friendly_value', 'no').lower(), None)
        if self.verbose==None:
            errors['friendly_value']='boolean must have value in (on, yes, true, 1, off, no, false and 0)'

        for name in ('class_list', 'class_include', 'class_exclude', 'property_exclude'):
            value=job.get(name, None)
            try:
                lst=quoted_string_list(job.get(name, ''))
            except ValueError:
                errors[name]='not a valid quoted string list'
            else:
                setattr(self, name, lst)
                
        if not self.class_list:
            self.class_list=default_class_list
            
        class_include_warnings=[]
        for cls in self.class_include:
            if not cls in self.class_list:
                self.class_list.append(cls)
            else:
                class_include_warnings.append(cls)
                
        class_exclude_warnings=[]
        for cls in self.class_exclude:
            if cls in self.class_list:
                self.class_list.remove(cls)
            else:
                class_exclude_warnings.append(cls)
                
        if class_include_warnings:
            warnings['class_include']='classes already in the list: '+','.join(class_include_warnings)
            
        if class_exclude_warnings:
            warnings['class_exclude']='classes not in the list: '+','.join(class_exclude_warnings)
            
                    
        if not errors:
            # upload and setup files on the VMWARE server
            extra='class list: '+', '.join(self.class_list)
            
            # make a try 
            wbemclient=pywbem.WBEMConnection(self.url, (self.login, self.password), self.NS)
            try:
                _instance_list=wbemclient.EnumerateInstances(test_class)
            except pywbem.cim_operations.CIMError, e:
                if e.args[0]==0:
                    log.exception('maybe something wrong with URL "%s": %s', self.url, e[1])
                    errors['url']='maybe something wrong with URL "%s": %s' % (self.url, e[1])
                elif e.args[0]==pywbem.CIM_ERR_NOT_FOUND:
                    pass # The requested object could not be found.
                else:
                    errors['url']="Unknown CIM Error: code=%s, msg=%s" % (e[0], e[1])
                    log.error("Unknown CIM Error: code=%s, msg=%s", e[0], e[1])
            except pywbem.cim_http.AuthError, e: 
                log.error("Authentication error: %s", e)
                errors['login']="Authentication error: %s" % (e,)

        return errors, warnings, extra

    # -----------------------------------------------------------------------
    def friendlyValue(self, client, instance, propertyName):
       # Start out with a default empty string, in case we don't have a mapping
       mapping=None
    
       if instance.classname not in self.classData:
          # Fetch the class metadata if we don't already have it in the cache
          self.classData[instance.classname]=client.GetClass(instance.classname, IncludeQualifiers=True)
    
       # Now scan through the qualifiers to look for ValueMap/Values sets
       qualifiers=self.classData[instance.classname].properties[propertyName].qualifiers
       if 'ValueMap' in qualifiers.keys() and 'Values' in qualifiers.keys():
          vals=qualifiers['Values'].value
          valmap=qualifiers['ValueMap'].value
          value=instance[propertyName]
          # Find the matching value and convert to the friendly string
          if isinstance(value, (list, tuple)):
              mapping=[]
              for v in value:
                  for i in range(0,len(valmap)-1):
                     if str(valmap[i]) == str(v):
                         mapping.append(vals[i])
                         break
              mapping=' ('+', '.join(mapping)+')'
         
          else:
              for i in range(0,len(valmap)-1):
                 if str(valmap[i])==str(value):
                     mapping=vals[i]
                     break
       return mapping

    # -----------------------------------------------------------------------
    def run(self, command, job, manager):

        log=manager.log
        now=manager.now

        start=int(time.time())
        log.info('start url=%s', self.url)

        global_status, data, error=ExitOK, '', ''

        wbemclient=pywbem.WBEMConnection(self.url, (self.login, self.password), self.NS)

        for cls in self.class_list:
            try:
                instance_list=wbemclient.EnumerateInstances(cls)
            except pywbem.cim_operations.CIMError, e:
                if e.args[0]==pywbem.CIM_ERR_NOT_FOUND:
                    log.warning('class %s: %s', cls, e.args[1])
                    continue
                else:
                    raise
            for instance in instance_list:
                elementName=instance['ElementName']
                title='===== %s %s =====' % (cls, elementName)
                for propertyName in sorted(instance.keys()):
                    if propertyName in self.property_exclude:
                        continue
                    if not self.verbose and propertyName not in ('OperationalStatus', 'HealthState'):
                        continue
                    if instance[propertyName] is None:
                        # skip over null properties
                        continue
                    value=None
                    if self.friendly_value:
                        value=self.friendlyValue(wbemclient, instance, propertyName)

                    if value==None:
                        value=instance[propertyName]
                        if isinstance(value, (list, tuple)):
                            value='('+', '.join(map(str, value))+')'
                        else:
                            value=str(value)
                            
                    if propertyName in ('OperationalStatus', 'HealthState'):
                        status=ExitOK
                        values=instance[propertyName]
                        if not isinstance(values, (list, tuple)):
                            values=[values, ]
                        for v in values:
                            s=self.interpret[propertyName].get(v, ExitUnknown)
                            status=max(status, s)
                        if status!=ExitOK:
                            error+='%s %s %s: %s\n' % (cls, elementName, propertyName, value)
                        global_status=max(global_status, status)
                    if title:
                        data+=title+'\n'
                        title=''
                    data+='\t%s=%s\n' % (propertyName, value) 

        end=int(time.time())
        
        if global_status==ExitOK:
            backup_status='OK'
        else:
            backup_status='ERR'

        log.debug('end status: %s', backup_status)

        status=u''
        attachments=[ # the type, subtype and coding is not used
                       ('output.txt', None, data, 'text', 'plain', 'utf-8'),
                    ]
        
        if error:
            attachments.insert(0, ('error.txt', None, error, 'text', 'plain', 'utf-8'))

        status=u''
        status+='name=%s\r\n' % job['name']
        status+='program=%s\r\n' % self.name
        status+='version=%s\r\n' % self.__version__
        status+='status=%s\r\n' % backup_status
        status+='hostname=%s\r\n' % manager.hostname
        
        status+='exit_code=%d\r\n' % global_status
        status+='start=%s\r\n' % time.ctime(start)
        status+='end=%s\r\n' % time.ctime(end)
        status+='start_epoch=%d\r\n' % start
        status+='end_epoch=%d\r\n' % end

        return backup_status, status, attachments
