#
# ghettovcb.py
#
# mkbackup ghettovcb frontent
#

import os, string, subprocess, fnmatch, platform
import posixpath

from datetime import datetime, timedelta

#import paramiko
import pywbem

from archiver import *
import cron

default_class_list=[
    'CIM_Sensor', 
    'CIM_PowerSupply',
    'CIM_Chassis', 
    'CIM_ComputerSystem',
    'CIM_NumericSensor',
#    'CIM_Memory',
    'CIM_PhysicalMemory',
    'CIM_Processor', 
    'CIM_LogRecord',
    'CIM_RecordLog',
    'CIM_EthernetPort',

    'CIM_SoftwareIdentity', 
    
    'OMC_SMASHFirmwareIdentity',
    'OMC_DiscreteSensor', 
    'OMC_Fan', 
    'OMC_PowerSupply',

    'OMC_RawIpmiSensor',
    'OMC_RawIpmiEntity',
    
    'VMware_StorageExtent',
    'VMware_Controller',
    'VMware_StorageVolume',
    'VMware_Battery',
    'VMware_SASSATAPort',
]


class ESXMon(Archiver):
    
    name='esxmon'

    types=dict( mon='mon')
    
    NS = 'root/cimv2'

    # -----------------------------------------------------------------------
    def __init__(self):
        Archiver.__init__(self)
        
        self.url=None
        self.login=None
        self.password=None

        self.class_list=[]
        self.class_include=[]
        self.class_exclude=[]
        
    
    # -----------------------------------------------------------------------
    def load(self, job, manager):
        
        log=manager.log
        now=manager.now
        
        errors, warnings, extra={}, {}, ''

        for name in ('url', 'login', 'password'):
            value=job.get(name, None)
            if not value:
                errors[name]='option mandatory'
            else:
                setattr(self, name, value)
                if name=='password':
                    self.register_password(value)

        for name in ('class_list', 'class_include', 'class_exclude' ):
            value=job.get(name, None)
            try:
                list=quoted_string_list(job.get(name, ''))
            except ValueError:
                errors[name]='not a valid quoted string list'
            else:
                setattr(self, name, list)
                
        if not self.class_list:
            self.class_list=default_class_list
            
        class_include_warnings=[]
        for cls in self.class_include:
            if not cls in self.class_list:
                self.class_list.append(cls)
            else:
                class_include_warnings.append(cls)
                
        class_exclude_warnings=[]
        for cls in self.class_exclude:
            if cls in self.class_list:
                self.class_list.remove(cls)
            else:
                class_exclude_warnings.append(cls)
                
        if class_include_warnings:
            warnings['class_include']='classes already in the list: '+','.join(class_include_warnings)
            
        if class_exclude_warnings:
            warnings['class_exclude']='classes not in the list: '+','.join(class_exclude_warnings)
            
                    
        if not errors:
            # upload and setup files on the VMWARE server
            extra='class list: '+', '.join(self.class_list)
            
            wbemclient=pywbem.WBEMConnection(self.url, (self.login, self.password), self.NS)
            for cls in self.class_list:
                instance_list=wbemclient.EnumerateInstances(cls)
                for instance in instance_list:
                    elementName=instance['ElementName']
                    print elementName
                    if instance['OperationalStatus'] is not None:
                        elementStatus=instance['OperationalStatus'][0]
                        print '\tOperationalStatus', elementStatus
                    if instance['HealthState'] is not None:
                        elementStatus=instance['HealthState']
                        print '\tHealthState', elementStatus
            
                
        return errors, warnings, extra

    # -----------------------------------------------------------------------
    def run(self, command, job, manager):

        any_error=False

        log=manager.log
        now=manager.now

        start=int(time.time())

        t=paramiko.Transport((self.host, self.port))
        t.get_security_options()._set_ciphers(['blowfish-cbc', ])
        t.connect(username=self.login, password=self.password)
        # t.set_keepalive(300) # make the backup fail
        chan=t.open_session()
        chan.set_combine_stderr(True)
        log.info('start: %s', self.cmd_line)
        chan.exec_command(self.cmd_line)
        output, line_buf='', ''
        while True:
            x=chan.recv(1024)
            if len(x)==0:
                break
            output+=x
            line_buf=line_buf+x
            lines=line_buf.split('\n')
            line_buf=lines[-1]
            for line in lines[:-1]:
                log.debug(line)

        if line_buf:
            log.debug(line_buf)
            
        ghettovcb_exit_code=chan.recv_exit_status()
        chan.close()
        end=int(time.time())
        log.debug('ghettovcb ssh exit code: %d', ghettovcb_exit_code)
        
        # ESX(i) return an unreliable exit_code   
        pos1=output.rfind('exit_code=')
        pos2=output.find('\n', pos1)
        ghettovcb_exit_code=int(output[pos1+10:pos2])
        output=output[:pos1]

        status=u''
        attachements=[ # the type, subtype and coding is not used
                       ('output.txt', None, output, 'text', 'plain', 'utf-8'),
                    ]

        # search in the output for the name of backed up vm
        # should be == to self.vm_list when provided
        vm_list=[]
        for line in output.split('\n'):
            current_error=False
            match=self.initiate_backup_re.match(line)
            if not match:
                continue
            
            current_vm=match.group('name')
            
            # read vm config file if it exist
            filename=os.path.join(self.local, current_vm)
            if os.path.isfile(filename):
                vm_var=self.read_vm_conf(filename, self.default_var)
            else:
                vm_var=self.default_var
                    
            # search the target and make a directory listing 
            dir_lst, up_lst, scp_process, target=None, None, None, None
            if vm_var['ENABLE_NON_PERSISTENT_NFS']!='1':
                target=posixpath.join(vm_var['VM_BACKUP_VOLUME'], current_vm)
                compress=vm_var['ENABLE_COMPRESSION']=='1'
                if compress:
                    _exit_code, dir_lst=RunCommand(t, 'ls -l "%s"' % target, log)
                    dir_lst='== directory '+target+'\n'+dir_lst
                else:
                    _exit_code, up_lst=RunCommand(t, 'ls "%s"' % target, log)
                    dir_lst=None
                    # search the target directory, take the last one
                    target_name=''
                    for line in up_lst.split('\n'):
                        if line.startswith(current_vm):
                            if line>target_name:
                               target_name=line
                    up_lst='== directory '+target+'\n'+up_lst
                    if target_name: 
                        target=posixpath.join(target, target_name)
                        _exit_code, dir_lst=RunCommand(t, 'ls -l "%s"' % target, log)
                        dir_lst='== directory '+target+'\n'+dir_lst

                if dir_lst:
                    attachements.append(('dir-%s.txt' % (current_vm,), None, dir_lst, 'text', 'plain', 'utf-8'))
        
                if up_lst:
                    attachements.append(('dirup-%s.txt' % (current_vm,), None, up_lst, 'text', 'plain', 'utf-8'))
        
                # if destination, move or copy backup
                if self.destination:
                    self.type, self.target=self.destination.match(now, self.night_shift, variables=dict(vm=current_vm))
                    if self.type in ('move', 'copy'):
                        if not compress:
                            # create the target dir, if don't exist
                            try:
                                if not os.path.isdir(self.target):
                                    os.makedirs(self.target)
                            except Exception, e:
                                log.error('creating directory %s: %s', self.target, e)
                                current_error=True
        
                        if not current_error:
                            start=int(time.time())
                            status+='remote_target-%s=%s\r\n' % (current_vm, target)
                            status+='target-%s=%s\r\n' % (current_vm, self.target)
                            if not self.scp_bin:
                                # use paramiko
                                try:
                                    scpclient=MySCPClient(t, buff_size=65536)
                                    log.info('scp -r %s %s', target, self.target)
                                    scpclient.get(target, self.target, recursive=True)
                                except SCPException:
                                    returncode=1
                                    current_error=True
                                else:
                                    returncode=0
                                status+='scp_exit_code-%s=%d\r\n' % (current_vm, returncode)
                            else:
                                # use local SCP
                                scp_args=self.scp_args[:]
                                if not compress:
                                    if sys.platform in ('win32', ):
                                        scp_args.append('-unsafe')
                                    #scp_args.append('-r')
                                    wildcard='/*'
                                else:
                                    wildcard=''
                                    
                                scp_args+=[ '%s@%s:%s%s' % (self.login, self.host, target, wildcard), self.target]
                                scp_cmd=self.hide_password(' '.join(scp_args))
                                log.info('scp_cmd=%s', scp_cmd)
                                if sys.platform in ('win32', ):
                                    scp_args=param_encode(scp_args, manager.default_encoding)
                                scp_process=subprocess.Popen(scp_args, executable=self.scp_bin, stdin=subprocess.PIPE, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
                                scp_out, scp_err=scp_process.communicate()
                                if scp_out:
                                    attachements.append(('scp_out-%s.txt' % (current_vm,), None, scp_out, 'text', 'plain', manager.console_encoding))
                                if scp_err:
                                    attachements.append(('scp_err-%s.txt' % (current_vm,), None, scp_err, 'text', 'plain', manager.console_encoding))
                                status+='scp_cmd-%s=%s\r\n' % (current_vm, scp_cmd)
                                status+='scp_exit_code-%s=%d\r\n' % (current_vm, scp_process.returncode)
                                
                                if scp_process.returncode!=0:
                                    current_error=True
                                
                            log.info('scp end')
                            
                            if self.type=='move':
                                # delete the source
                                log.info('delete %s', target)
                                _exit_code, _rm_out=RunCommand(t, 'rm -r "%s"' % target, log)
        
                            try:
                                total_free_bytes=free_space(self.target, log)
                            except Exception, e:
                                log.error('checking target directory: %s', e)
                                status+='target_free_space-%s=%s\r\n' % (current_vm, e)
                            else:
                                status+='target_free_space-%s=%d\r\n' % (current_vm, total_free_bytes)
                
                            dir_out, _total_size=list_dir(self.target, log)        
                            attachements.append(('target_dir-%s.txt' % (current_vm,), None, dir_out.encode('utf-8'), 'text', 'plain', 'utf-8'))

                            end=int(time.time())
                            status+='scp_start-%s=%s\r\n' % (current_vm, time.ctime(start))
                            status+='scp_end-%s=%s\r\n' % (current_vm, time.ctime(end))
                            status+='scp_start_epoch-%s=%d\r\n' % (current_vm, start)
                            status+='scp_end_epoch-%s=%d\r\n' % (current_vm, end)


            any_error=any_error or current_error
        
        # make the disk space usage
        _exit_code, df=RunCommand(t, 'df', log)
        
        # make volume listing 
        _exit_code, ls_volumes=RunCommand(t, 'ls -l /vmfs/volumes', log)
        ls_volumes='== directory /vmfs/volumes\n'+ls_volumes

        t.close()

        if ghettovcb_exit_code==0 and not any_error:
            backup_status='OK'
        else:
            backup_status='ERR'

        status_pre=u''
        status_pre+='name=%s\r\n' % job['name']
        status_pre+='program=%s\r\n' % self.name
        status_pre+='version=%s\r\n' % self.__version__
        status_pre+='status=%s\r\n' % backup_status
        status_pre+='hostname=%s\r\n' % manager.hostname
        
        status_pre+='exit_code=%d\r\n' % ghettovcb_exit_code
        status_pre+='start=%s\r\n' % time.ctime(start)
        status_pre+='end=%s\r\n' % time.ctime(end)
        status_pre+='start_epoch=%d\r\n' % start
        status_pre+='end_epoch=%d\r\n' % end

        status_pre+='type=%s\r\n' % self.type
        status=status_pre+status
        
        if df:
            attachements.insert(0, ('df.txt', None, df, 'text', 'plain', 'utf-8'),)

        if ls_volumes:
            attachements.insert(0, ('ls_volumes.txt', None, ls_volumes, 'text', 'plain', 'utf-8'),)

        
        return backup_status, status, attachements
