import sys, os
# ... http://www.py2exe.org/index.cgi/win32com.shellhttp://www.py2exe.org/index.cgi/win32com.shell
# ModuleFinder can't handle runtime changes to __path__, but win32com uses them
try:
    # py2exe 0.6.4 introduced a replacement modulefinder.
    # This means we have to add package paths there, not to the built-in
    # one.  If this new modulefinder gets integrated into Python, then
    # we might be able to revert this some day.
    # if this doesn't work, try import modulefinder
    try:
        import py2exe.mf as modulefinder
    except ImportError:
        import modulefinder
    import win32com
    for p in win32com.__path__[1:]:
        modulefinder.AddPackagePath("win32com", p)
    for extra in ["win32com.shell"]: #,"win32com.mapi"
        __import__(extra)
        m = sys.modules[extra]
        for p in m.__path__[1:]:
            modulefinder.AddPackagePath(extra, p)
except ImportError:
    # no build path setup, no worries.
    pass

from distutils.core import setup

# retrieve $version
version=''
for line in open(os.path.join('mkb', 'mkbackup.py')):
    if line.startswith("__version__="):

        version=line[13:].rstrip()[:-1]
        break

if not version:
    print 
    print '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
    print '!                                             !'
    print '!            VERSION NOT FOUND                !'
    print '!                                             !'
    print '!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
    sys.exit(1)

print 'VERSION', version

extra_options = {}
win32zip=None
doc_dir='share/doc/mkbackup-%s' % (version,)

if os.name=='nt':
    doc_dir='.'
    try:
        import py2exe
    except ImportError:
        pass
    else:
        win32zip='mkbackup-%s' % (version, )
        py2exe_options =  { 'packages':['email',], 
                            'dll_excludes': ['w9xpopen.exe'], 
                            'compressed':True, 
                            'dist_dir': win32zip, }
        extra_options = { 'console': ['mkbackup'], 
                          'options': { 'py2exe': py2exe_options, }
                        }
        if '--single-file' in sys.argv[1:]:
            sys.argv.remove('--single-file')
            py2exe_options.update({ 'bundle_files': 1, })
            extra_options.update({ 'zipfile': None, })

setup(name='mkbackup',
      version=version, 
      author='Alain Spineux',
      author_email='alain.spineux@gmail.com',
      url='http://www.magikmon.com/mkbackup',
      description='Frontend for popular windows and linux backup tools',
      long_description='Run the appropriate backend, and send a mail report',
      license='GPL',
      packages=[ 'mkb' ],
      scripts=['mkbackup',],
      data_files=[ (doc_dir, [ 'README.txt', 'Changelog.txt', 'LICENSE.txt', 'ghettoVCB.txt', 'sample.ini' ])
                 ],
      **extra_options)

if win32zip:
    import zipfile
    try:
        os.mkdir('dist')
    except OSError:
        pass
    zfilename=os.path.join('dist', win32zip+'-win32.zip')
    try:
        os.unlink(zfilename)
    except WindowsError:
        pass
    
    zfile=zipfile.ZipFile(zfilename, "w")
    for root, dirs, files in os.walk(win32zip):
        print root, dirs, files
        for f in files:
            filename=os.path.join(root, f)
            zfile.write(filename)

    zfile.close()
    
    # rename win32zip into "mkbackup-win32"
    # first delete mkbackup-win32
    target='mkbackup-win32'
    for root, dirs, files in os.walk(target, topdown=False):
        for name in files:
            os.remove(os.path.join(root, name))
        for name in dirs:
            os.rmdir(os.path.join(root, name))
    os.rmdir(target)
    os.rename(win32zip, target)


